#include "General.h"
#include "GameSpy_Support.h"
#include "GameSpyClass.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

bool GameSpy_Support::ShowGameMode, GameSpy_Support::ShowDriverGunner, GameSpy_Support::ShowTeamChanging, GameSpy_Support::UseTotalPlayerTime, GameSpy_Support::NoWOLAppendPlayerCount, 
GameSpy_Support::ShowFriendlyFire, GameSpy_Support::ShowCredits, GameSpy_Support::ShowTimeLeft, GameSpy_Support::ShowPedestal, GameSpy_Support::ShowRotation;
bool GameSpy_Support::Loaded = false;
int GameSpy_Support::MaxPlayers, GameSpy_Support::ListenPort;
DynamicVectorClass<StringClass> GameSpy_Support::ExtraStringList;
StringClass GameSpy_Support::CustomGameTitle, GameSpy_Support::GameMode,  GameSpy_Support::PlayerTimeMode;
WideStringClass GameSpy_Support::GameTitle;

GameSpy_Support::GameSpy_Support()
{
	//Console_Output("PLAYERS; %d\n", The_Game()->Get_Current_Players()); // DEBUG CRAP
	RegisterEvent(EVENT_GLOBAL_INI,this);
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
	RegisterEvent(EVENT_PLAYER_JOIN_HOOK,this);
	RegisterEvent(EVENT_PLAYER_LEAVE_HOOK,this);
}

GameSpy_Support::~GameSpy_Support()
{
	UnregisterEvent(EVENT_GLOBAL_INI,this);
	UnregisterEvent(EVENT_PLAYER_JOIN_HOOK,this);
	UnregisterEvent(EVENT_PLAYER_LEAVE_HOOK,this);
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}

void GameSpy_Support::OnLoadLevel()
{
}

void GameSpy_Support::OnLoadGlobalINISettings(INIClass *SSGMIni)
{
	for (int z = 1; ; ++z) 
	{
		char value[500];
		StringClass tmp;
		tmp.Format("%02d",z);
		SSGMIni->Get_String("GameSpy_Support_ExtraStrings",tmp,"NULL",value,500); //load from section [GameSpy_Support_ExtraStrings] in ssgm.ini
		if (!stricmp(value,"NULL")) 
		{
			break;
		}
		ExtraStringList.Add(value);
	}

	SSGMIni->Get_String(CustomGameTitle, "GameSpy_Support", "CustomGameTitle", "Change this, bro");
	SSGMIni->Get_String(GameMode, "GameSpy_Support", "GameMode", "Change this, bro");
	SSGMIni->Get_String(PlayerTimeMode, "GameSpy_Support", "PlayerTimeMode", "total");
	MaxPlayers = SSGMIni->Get_Int("GameSpy_Support", "MaxPlayers", 0);
	ListenPort = SSGMIni->Get_Int("GameSpy_Support", "ListenPort", 0);
	ShowDriverGunner = SSGMIni->Get_Bool("GameSpy_Support", "ShowDriverGunner", 0);
	ShowTeamChanging = SSGMIni->Get_Bool("GameSpy_Support", "ShowTeamChanging", 0);
	ShowFriendlyFire = SSGMIni->Get_Bool("GameSpy_Support", "ShowFriendlyFire", 0);
	ShowGameMode = SSGMIni->Get_Bool("GameSpy_Support", "ShowGameMode", 0);
	ShowCredits = SSGMIni->Get_Bool("GameSpy_Support", "ShowCredits", 0);
	ShowTimeLeft = SSGMIni->Get_Bool("GameSpy_Support", "ShowTimeLeft", 0);
	ShowPedestal = SSGMIni->Get_Bool("GameSpy_Support", "ShowPedestal", 0);
	ShowRotation = SSGMIni->Get_Bool("GameSpy_Support", "ShowRotation", 0); 
	NoWOLAppendPlayerCount = SSGMIni->Get_Bool("GameSpy_Support", "NoWOLAppendPlayerCount", 1);

	GameTitle = The_Game()->Get_Game_Title();

	GameSpy_Support::UseTotalPlayerTime = false;
	if ( GameSpy_Support::PlayerTimeMode == "Total" || GameSpy_Support::PlayerTimeMode == "total" )
	{
		GameSpy_Support::UseTotalPlayerTime = true;
	}
	else if( GameSpy_Support::PlayerTimeMode == "Gamestart" ||  GameSpy_Support::PlayerTimeMode == "gamestart" )
	{
		GameSpy_Support::UseTotalPlayerTime = false;
	}
	if (!GameSpy_Support::Loaded)
	{
		GameSpy::StartUp();
	}
}

void Set_WOL_Game_Title()
{
	if ( !GameSpy_Support::NoWOLAppendPlayerCount ) // If we append player count to server name
	{
		The_Game()->Get_Game_Title().Format(L"%s (%d/%d)",
			GameSpy_Support::GameTitle, The_Game()->Get_Current_Players(), The_Game()->Get_Max_Players());
	}
}

void GameSpy_Support::OnPlayerJoin(int PlayerID,const char *PlayerName)
{
	GameSpy::SetJoinTime(PlayerID, time(NULL));

	Set_WOL_Game_Title();
}

void GameSpy_Support::OnPlayerLeave(int PlayerID)
{
	GameSpy::SetJoinTime(PlayerID, 0);

	Set_WOL_Game_Title();
}

DWORD WINAPI Do_GameSpy_Heart_Beat(LPVOID params)
{
	for (;;)
	{		
		GameSpy::DoHeartBeat();
		Sleep(15000); // 15 seconds
	}
	return 0;
}

// We set the game title on player join/leave now instead of in a dedicated thread with this code

/* DWORD WINAPI Set_Player_Count_Game_Title(LPVOID params)
{
	char tmp[128];
	for (;;)
	{
		memset(tmp, 0x0, 128);		
		sprintf(tmp, "%s (%d/%d)", GameSpy_Support::GameTitle.Peek_Buffer(), The_Game()->Get_Current_Players(), The_Game()->Get_Max_Players());
		const wchar_t *Data = CharToWideChar(tmp);
		The_Game()->Set_Game_Title(Data);
		delete []Data;
		Sleep(5000); // 5 seconds
	}
	return 0;
} */

GameSpy_Support GameSpy_Support;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &GameSpy_Support;
}